/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.access.api.AcaMrGroup;
import com.ibm.hsc.access.api.AcaRole;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.AccDataBean;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.websm.diagnostics.IDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class AccList {
    private static final String[] m_validOpts = new String[]{"-t", "--filter", "--header", "-F", "--long", "--script", "--help"};
    private String[] m_AllProps = new String[]{"name", "parent", "resource"};
    private String[] m_AllGrpProps = new String[]{"name", "resource"};
    private String[] m_AllRsrcProps = new String[]{"resource"};
    private String m_target = null;
    private String m_filter = null;
    private boolean m_long = false;
    private boolean m_script = false;
    private boolean m_header = false;
    private boolean m_format = false;
    private String m_delimiter = ",";
    private String[] m_actualKeys;
    public AcaClient m_acaCl = null;
    private Vector m_filterVt = new Vector();

    public AccList() {
        this.m_actualKeys = this.m_AllProps;
    }

    private AccDataBean doOneGroup(String string) {
        AccUtils.DBG("doOneGroup=" + string);
        if (string == null || string.length() <= 0) {
            return null;
        }
        AcaMrGroup acaMrGroup = this.m_acaCl.GetGroupProperty(string);
        if (acaMrGroup == null) {
            return null;
        }
        AccDataBean accDataBean = new AccDataBean();
        accDataBean.setMrGroup(acaMrGroup);
        Vector<AccDataBean> vector = new Vector<AccDataBean>();
        vector.add(accDataBean);
        AccUtils.DBG("m_actualKeys.size==" + this.m_actualKeys.length);
        return accDataBean;
    }

    private AccDataBean doOneRole(String string) {
        AccUtils.DBG("doOneRole=" + string);
        if (string == null || string.length() <= 0) {
            return null;
        }
        AcaRole acaRole = this.m_long ? this.m_acaCl.GetRoleProperty(string) : this.m_acaCl.GetRoleProperty(string, 2);
        String string2 = "";
        if (acaRole == null) {
            return null;
        }
        AccDataBean accDataBean = new AccDataBean();
        accDataBean.setAcaRole(acaRole);
        if (this.m_long) {
            accDataBean.setFlags(1);
        }
        return accDataBean;
    }

    private AccDataBean doGetInstances() throws PIHscClientException {
        int n;
        AccUtils.DBG("doGetInstances filter= " + this.m_filter);
        Vector<String> vector = null;
        String[] stringArray = null;
        if (this.m_filter != null) {
            int n2;
            AccUtils.DBG("rsrc types= " + this.m_filterVt);
            for (n2 = 0; n2 < this.m_filterVt.size(); ++n2) {
                stringArray = this.m_script ? this.m_acaCl.getInstances((String)this.m_filterVt.get(n2), 1) : this.m_acaCl.getInstances((String)this.m_filterVt.get(n2), 3);
                if (stringArray == null) continue;
                if (vector == null) {
                    vector = new Vector<String>();
                }
                for (n = 0; n < stringArray.length; ++n) {
                    vector.add(stringArray[n]);
                }
            }
            if (vector != null) {
                AccUtils.DBG("rsrc vector = " + vector.toString());
                stringArray = new String[vector.size()];
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    stringArray[n2] = (String)vector.get(n2);
                    AccUtils.DBG("rsrc list k = " + n2 + " = " + stringArray);
                }
            } else {
                stringArray = null;
            }
            AccUtils.DBG("AccList:resources = " + stringArray);
        } else {
            stringArray = this.m_script ? this.m_acaCl.getInstances(1) : this.m_acaCl.getInstances(3);
        }
        if (stringArray == null) {
            AccUtils.DBG("AccList:resources is null");
            String string = this.m_acaCl.GetMessage();
            AccUtils.throwCommandError(string);
        }
        String[] stringArray2 = null;
        if (this.m_script) {
            stringArray2 = stringArray;
        } else {
            stringArray2 = new String[stringArray.length / 2];
            n = 0;
            for (int i = 0; i < stringArray.length; i += 2) {
                stringArray2[n] = "<ResourceID = " + stringArray[i] + ">" + "<UserDefinedName = " + stringArray[i + 1] + ">";
                ++n;
            }
        }
        AccDataBean accDataBean = new AccDataBean();
        accDataBean.setInstances(stringArray2);
        return accDataBean;
    }

    public void performCommand() throws HSCException, PIHscClientException {
        AccDataBean accDataBean;
        String string = "";
        String string2 = "";
        String string3 = "";
        Hashtable hashtable = new Hashtable();
        Object var5_5 = null;
        AccUtils.DBG("m_target=" + this.m_target);
        AccUtils.DBG("m_filter=" + this.m_filter);
        AccUtils.DBG("m_long =" + this.m_long + " m_script = " + this.m_script);
        Vector<AccDataBean> vector = new Vector<AccDataBean>();
        if (this.m_target.equals("taskrole")) {
            String[] stringArray = this.m_acaCl.GetRoles("");
            for (int i = 0; i < stringArray.length; ++i) {
                AccDataBean accDataBean2;
                if (this.m_filter != null && !this.m_filterVt.contains(stringArray[i]) || (accDataBean2 = this.doOneRole(stringArray[i])) == null) continue;
                vector.add(accDataBean2);
            }
        } else if (this.m_target.equals("resourcerole")) {
            String[] stringArray = this.m_acaCl.GetGroups("");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    AccDataBean accDataBean3;
                    if (this.m_filter != null && !this.m_filterVt.contains(stringArray[i]) || (accDataBean3 = this.doOneGroup(stringArray[i])) == null) continue;
                    vector.add(accDataBean3);
                }
            }
        } else if (this.m_target.equals("resource") && (accDataBean = this.doGetInstances()) != null) {
            vector.add(accDataBean);
        }
        PICmdOutputUtils.printResults(vector.elements(), this.m_actualKeys, this.m_delimiter, this.m_header, !this.m_format);
    }

    private void parseFilter(String string) throws PIHscClientException {
        AccUtils.DBG("In parseFilter " + string);
        if (string.indexOf("=") < 0) {
            AccUtils.throwCmdLineSyntaxError(string, "INVALID_FILTER");
        }
        String string2 = string.substring(0, string.indexOf("="));
        AccUtils.DBG("filterName=" + string2);
        AccUtils.DBG("tartget=" + this.m_target);
        if (this.m_target.equals("taskrole") && !string2.equals("taskroles") || this.m_target.equals("resource") && !string2.equals("resource_type") || this.m_target.equals("resourcerole") && !string2.equals("resourceroles")) {
            AccUtils.throwCmdLineSyntaxError(string, "INVALID_FILTER_NAME");
        }
        String string3 = string.substring(string.indexOf("=") + 1);
        String[] stringArray = PIHMCCommandUtils.parseList(string3, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_filterVt.add(stringArray[i]);
        }
        this.m_filterVt.trimToSize();
        AccUtils.DBG("m_filterVt.size()=" + this.m_filterVt.size());
        if (this.m_filterVt.size() == 0) {
            AccUtils.throwCmdLineSyntaxError(string, "INVALID_FILTER");
        }
        AccUtils.DBG("Out parseFilter " + string);
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException, PIHscClientException {
        AccUtils.DBG("In mapParameters");
        String string = AccUtils.validateCmdOptions(m_validOpts, hashMap);
        if (string != null && string.length() > 0) {
            AccUtils.throwCmdLineSyntaxError(string, "INVALID_PARM");
        }
        this.m_target = (String)hashMap.get("-t");
        this.m_filter = (String)hashMap.get("--filter");
        String string2 = (String)hashMap.get("--header");
        this.m_header = string2 != null;
        String string3 = (String)hashMap.get("-F");
        this.m_long = hashMap.containsKey("--long");
        this.m_script = hashMap.containsKey("--script");
        if (this.m_target == null || !this.m_target.equals("taskrole") && !this.m_target.equals("resourcerole") && !this.m_target.equals("resource")) {
            String[] stringArray = new String[]{"-t taskrole|resourcerole|resource"};
            AccUtils.throwRequiredParam(stringArray);
        }
        this.m_target = this.m_target.trim();
        if (this.m_target.equals("taskrole")) {
            this.m_actualKeys = this.m_AllProps;
        } else if (this.m_target.equals("resourcerole")) {
            this.m_actualKeys = this.m_AllGrpProps;
        } else if (this.m_target.equals("resource")) {
            this.m_actualKeys = this.m_AllRsrcProps;
        }
        if (this.m_filter != null) {
            this.parseFilter(this.m_filter);
        }
        if (string3 != null && string3.length() > 0) {
            try {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(string3, this.m_AllProps, this.m_AllProps.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                if (this.m_target.equals("taskrole")) {
                    this.m_actualKeys = PICmdOutputUtils.checkKeys(this.m_AllProps, string3, this.m_delimiter);
                } else if (this.m_target.equals("resourcerole")) {
                    this.m_actualKeys = PICmdOutputUtils.checkKeys(this.m_AllGrpProps, string3, this.m_delimiter);
                } else if (this.m_target.equals("resource")) {
                    this.m_actualKeys = PICmdOutputUtils.checkKeys(this.m_AllRsrcProps, string3, this.m_delimiter);
                }
                this.m_format = true;
            }
            catch (PIHscClientException pIHscClientException) {
                String[] stringArray = new String[]{"-F " + string3};
                AccUtils.throwRequiredParam(stringArray);
            }
        }
        AccUtils.DBG("cmdParams=" + hashMap);
    }

    public void printHelp() {
        AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ACCLIST_HELP"));
    }

    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            String string2 = null;
            AccList accList = new AccList();
            if (stringArray.length == 0) {
                accList.printHelp();
            } else {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = stringArray[i];
                    arrayList.add(string2);
                    if (!string2.equals("--help")) continue;
                    accList.printHelp();
                    bl = true;
                    break;
                }
                if (!bl) {
                    HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                    accList.mapParameters(hashMap);
                    accList.m_acaCl = new AcaClient(1);
                    accList.performCommand();
                }
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            AccUtils.DBG("Get HSCException");
            string = hSCException.getMessage();
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            AccUtils.DBG("Get RequiredParameterException");
            string = requiredParameterException.getMessage();
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                pIHscClientException.printStackTrace();
            }
            AccUtils.DBG("Get PIHscClientException");
            string = pIHscClientException.getMessage();
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            AccUtils.DBG("Get Throwable");
            string = throwable.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            AccUtils.SHOW(string);
            System.exit(1);
        }
        System.exit(0);
    }
}

